//
//  GSDialogController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 12.09.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@class GSDialogController;

@protocol GSDialogDelegateProtocol <NSObject>
@optional
- (void)confirmDialog:(nullable id)sender;

- (void)cancelDialog:(nullable id)sender;

- (NSString *)okButtonTitleForDialog:(GSDialogController *)dialog;

- (void)prepareWindow:(NSWindow *)window;
@end

@interface GSDialogController : NSWindowController <NSWindowDelegate>

@property (nonatomic, weak) id<GSDialogDelegateProtocol> delegate;
@property (nonatomic, weak) IBOutlet NSButton *okButton;
@property (nonatomic, weak) IBOutlet NSButton *cancelButton;
@property (nonatomic, weak) IBOutlet NSButton *menuButton;
@property (nonatomic, weak) IBOutlet NSLayoutConstraint *bottomConstraint;
@property (nonatomic, weak) IBOutlet NSStackView *buttonsStack;


@property (nonatomic) BOOL useLargeButtons;

- (instancetype)initWithController:(nullable id<GSDialogDelegateProtocol>)delegate;

- (void)setContentView:(NSView *)contentView;

- (NSModalResponse)runDialog:(nullable id)sender;

- (NSModalResponse)runDialog:(nullable id)sender modalForWindow:(nullable NSWindow *)window;

- (void)beginSheetModalForWindow:(NSWindow *)window completionHandler:(void (^_Nullable)(NSModalResponse returnCode))handler;

- (void)setTitle:(nullable NSString *)title;

- (void)setOkStringValue:(nullable NSString *)aString;

/**
 Call this method if you want a different OK action than `okPressed:`.
 */
- (void)setOKSelector:(SEL _Nullable)aSelector;

/**
 Call this method if you want a different Cancel action than `cancelPressed:`.
 */
- (void)setCancelSelector:(SEL)aSelector;

/**
 Default OK action; implementation does nothing.
 */
- (IBAction)okPressed:(id)sender;

- (IBAction)okDialogSheet:(id)sender;
/**
 Default Cancel action; implementation does nothing.
 */
- (IBAction)cancelPressed:(id)sender;

- (void)addHelpMenuItem:(NSMenuItem *)item;

@end
NS_ASSUME_NONNULL_END
